jQuery(document).ready(function($) {

    // --- Lógica para la ventana modal de vista previa ---

    var modal = $('#aics-content-modal');
    var modalTitleInput = $('#aics-modal-title-input');
    var modalBody = $('#aics-modal-body');
    var modalTagsInput = $('#aics-modal-tags-input');
    var closeModal = $('.aics-modal-close');
    var createDraftBtn = $('#aics-modal-create-draft');
    var publishBtn = $('#aics-modal-publish-directly');
    var scheduleBtn = $('#aics-modal-schedule');
    var scheduleContainer = $('#aics-schedule-container');
    var confirmScheduleBtn = $('#aics-schedule-confirm');
    var regenerateBtn = $('#aics-modal-regenerate');
    var spinner = $('.aics-modal-footer .spinner');

    // Abrir la modal al hacer clic en "Ver Contenido"
    // Usamos delegación de eventos para que funcione con cualquier elemento con esa clase, ahora o en el futuro.
    $(document).on('click', '.aics-view-content-btn', function(e) {
        e.preventDefault();

        var articleId = $(this).data('id');
        var title = $(this).data('title');
        var content = $(this).data('content');
        var tags = $(this).data('tags');
        var regenerateOnOpen = $(this).data('regenerate-on-open') === true;

        // Guardar el ID del artículo en la modal para usarlo después
        modal.data('article-id', articleId);

        modalTitleInput.val(title);
        modalTagsInput.val(tags || '');
        modalBody.html(content); // Usamos .html() para interpretar los <p>

        modal.show();

        // Si es un feed original, preguntamos para confirmar y disparamos la regeneración automáticamente.
        if (regenerateOnOpen) {
            // Primero, ocultamos los botones de publicación y guardado.
            createDraftBtn.hide();
            publishBtn.hide();
            scheduleBtn.hide();

            // Ahora, pedimos confirmación y si el usuario acepta, disparamos la regeneración.
            if (confirm('Esto consumirá créditos de la API para generar una nueva versión del artículo. ¿Estás seguro?')) {
                regenerateBtn.click();
            }
        } else {
            createDraftBtn.show();
            publishBtn.show();
            scheduleBtn.show();
        }
    });

    function hideModal() {
        modal.hide();
        modalTitleInput.val('');
        modalBody.html('');
        modalTagsInput.val('');
        modal.removeData('article-id');
        spinner.removeClass('is-active');
        scheduleContainer.hide(); // Ocultar el programador al cerrar
        publishBtn.prop('disabled', false);
        createDraftBtn.prop('disabled', false);
        regenerateBtn.prop('disabled', false);

        // Recargar la página para asegurar que el dashboard esté actualizado.
        location.reload();
    }

    // Cerrar la modal al hacer clic en la 'x'
    closeModal.on('click', function() {
        hideModal();
    });

    // NUEVO: Cerrar la modal con el botón del footer
    $(document).on('click', '#aics-modal-close-footer', function() {
        hideModal();
    });

    // Cerrar la modal al hacer clic fuera del contenido
    $(window).on('click', function(e) {
        if ($(e.target).is(modal)) {
            hideModal();
        }
    });

    // NUEVO: Mostrar/ocultar el panel de programación
    scheduleBtn.on('click', function() {
        scheduleContainer.slideToggle();
        // Poner fecha y hora actuales por defecto
        var now = new Date();
        var date = now.toISOString().substring(0, 10);
        var time = now.toTimeString().substring(0, 5);
        $('#aics-schedule-date').val(date);
        $('#aics-schedule-time').val(time);
    });

    // Acción para crear el borrador
    createDraftBtn.on('click', function() {
        var articleId = modal.data('article-id');

        if (!articleId) {
            alert('Error: No se pudo obtener el ID del artículo.');
            return;
        }

        spinner.addClass('is-active');
        createDraftBtn.prop('disabled', true);
        publishBtn.prop('disabled', true);
        scheduleBtn.prop('disabled', true);
        regenerateBtn.prop('disabled', true);

        $.ajax({
            url: aics_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'aics_create_draft_from_modal', // Acción para crear el borrador
                nonce: aics_ajax_object.nonce, // El nonce que pasaremos desde PHP
                article_id: articleId,
            },
            success: function(response) {
                if (response.success) {
                    // Eliminar la fila de la tabla del dashboard
                    $('#aics-article-row-' + articleId).fadeOut(400, function() { $(this).remove(); });
                    alert('Borrador creado con éxito.');
                    hideModal();
                } else {
                    alert('Error: ' + response.data.message);
                    spinner.removeClass('is-active');
                    scheduleBtn.prop('disabled', false);
                    publishBtn.prop('disabled', false);
                    createDraftBtn.prop('disabled', false);
                    regenerateBtn.prop('disabled', false);
                }
            },
            error: function() {
                alert('Ha ocurrido un error de comunicación con el servidor.');
                spinner.removeClass('is-active');
                scheduleBtn.prop('disabled', false);
                publishBtn.prop('disabled', false);
                createDraftBtn.prop('disabled', false);
                regenerateBtn.prop('disabled', false);
            }
        });
    });

    // Acción para publicar directamente
    publishBtn.on('click', function() {
        var articleId = modal.data('article-id');

        if (!articleId) {
            alert('Error: No se pudo obtener el ID del artículo.');
            return;
        }

        if (confirm('Esto publicará el artículo inmediatamente en tu sitio. ¿Estás seguro?')) {
            spinner.addClass('is-active');
            createDraftBtn.prop('disabled', true);
            publishBtn.prop('disabled', true);
            scheduleBtn.prop('disabled', true);
            regenerateBtn.prop('disabled', true);

            $.ajax({
                url: aics_ajax_object.ajax_url,
                type: 'POST',
                data: {
                    action: 'aics_publish_directly_from_modal', // Nueva acción AJAX
                    nonce: aics_ajax_object.nonce,
                    article_id: articleId,
                },
                success: function(response) {
                    if (response.success) {
                        $('#aics-article-row-' + articleId).fadeOut(400, function() { $(this).remove(); });
                        alert('Artículo publicado con éxito.');
                        hideModal();
                    } else {
                        alert('Error al publicar: ' + response.data.message);
                        spinner.removeClass('is-active');
                        createDraftBtn.prop('disabled', false);
                        scheduleBtn.prop('disabled', false);
                        publishBtn.prop('disabled', false);
                        regenerateBtn.prop('disabled', false);
                    }
                },
                error: function() {
                    alert('Ha ocurrido un error de comunicación con el servidor.');
                    spinner.removeClass('is-active');
                    createDraftBtn.prop('disabled', false);
                    scheduleBtn.prop('disabled', false);
                    publishBtn.prop('disabled', false);
                    regenerateBtn.prop('disabled', false);
                }
            });
        }
    });
    
    // NUEVO: Acción para confirmar la programación
    confirmScheduleBtn.on('click', function() {
        var articleId = modal.data('article-id');
        var scheduleDate = $('#aics-schedule-date').val();
        var scheduleTime = $('#aics-schedule-time').val();

        if (!articleId || !scheduleDate || !scheduleTime) {
            alert('Por favor, selecciona una fecha y hora para programar.');
            return;
        }

        var scheduleDateTime = scheduleDate + ' ' + scheduleTime;

        spinner.addClass('is-active');
        createDraftBtn.prop('disabled', true);
        publishBtn.prop('disabled', true);
        scheduleBtn.prop('disabled', true);
        regenerateBtn.prop('disabled', true);

        $.ajax({
            url: aics_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'aics_schedule_post_from_modal', // Nueva acción AJAX
                nonce: aics_ajax_object.nonce,
                article_id: articleId,
                schedule_datetime: scheduleDateTime
            },
            success: function(response) {
                if (response.success) {
                    $('#aics-article-row-' + articleId).fadeOut(400, function() { $(this).remove(); });
                    alert('Artículo programado con éxito.');
                    hideModal();
                } else {
                    alert('Error al programar: ' + response.data.message);
                    spinner.removeClass('is-active');
                    createDraftBtn.prop('disabled', false);
                    publishBtn.prop('disabled', false);
                    scheduleBtn.prop('disabled', false);
                    regenerateBtn.prop('disabled', false);
                }
            },
            error: function() {
                alert('Ha ocurrido un error de comunicación con el servidor.');
                spinner.removeClass('is-active');
                createDraftBtn.prop('disabled', false);
                publishBtn.prop('disabled', false);
                scheduleBtn.prop('disabled', false);
                regenerateBtn.prop('disabled', false);
            }
        });
    });

    // Acción para regenerar el contenido
    regenerateBtn.on('click', function() {
        var articleId = modal.data('article-id');

        if (!articleId) {
            alert('Error: No se pudo obtener la información del artículo.');
            return;
        }

        if (confirm('Esto consumirá créditos de la API para generar una nueva versión del artículo. ¿Estás seguro?')) {
            spinner.addClass('is-active');
            createDraftBtn.prop('disabled', true);
            publishBtn.prop('disabled', true);
            scheduleBtn.prop('disabled', true);
            regenerateBtn.prop('disabled', true);

            $.ajax({
                url: aics_ajax_object.ajax_url,
                type: 'POST',
                data: {
                    action: 'aics_regenerate_content', // Nuestra nueva acción AJAX
                    nonce: aics_ajax_object.nonce,
                    article_id: articleId
                },
                success: function(response) {
                    if (response.success) {
                        // Actualizar la modal con el nuevo contenido
                        modalTitleInput.val(response.data.title);
                        modalTagsInput.val(response.data.tags);
                        modalBody.html(response.data.content);
                        // NUEVO: Actualizar el título en la tabla del dashboard en tiempo real.
                        $('#aics-article-row-' + articleId).find('td:first-child strong').text(response.data.title);
                        
                        // Si el contenido se regeneró con éxito, mostramos los botones de acción
                        // que estaban ocultos para los feeds originales.
                        createDraftBtn.show();
                        publishBtn.show();
                        scheduleBtn.show();
                        $('#aics-article-row-' + articleId).find('.edit').show(); // Mostrar "Crear Borrador" en la fila

                        alert('¡Contenido regenerado con éxito!');
                    } else {
                        alert('Error al regenerar: ' + response.data.message);
                    }
                    spinner.removeClass('is-active');
                    createDraftBtn.prop('disabled', false);
                    publishBtn.prop('disabled', false);
                    scheduleBtn.prop('disabled', false);
                    regenerateBtn.prop('disabled', false);
                },
                error: function() {
                    alert('Ha ocurrido un error de comunicación con el servidor al regenerar.');
                    spinner.removeClass('is-active');
                    publishBtn.prop('disabled', false);
                    createDraftBtn.prop('disabled', false);
                    regenerateBtn.prop('disabled', false);
                }
            });
        }
    });

    // --- Lógica para el botón de Cargar Feeds RSS ---
    $('#aics-load-feeds-btn').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $spinner = $('#aics-load-feeds-spinner');

        // Deshabilitar el botón y mostrar el spinner
        $button.addClass('disabled');
        $spinner.show();

        $.ajax({
            url: aics_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'aics_load_rss_feeds',
                nonce: aics_ajax_object.nonce
            },
            success: function(response) {
                // Ocultar el spinner y reactivar el botón ANTES de cualquier otra acción.
                $spinner.hide();
                $button.removeClass('disabled');

                if (response.success) {
                    alert(response.data.message);
                    location.reload();
                } else {
                    alert('Error al cargar los feeds: ' + response.data.message);
                }
            },
            error: function() {
                // Ocultar el spinner y reactivar el botón en caso de error.
                $spinner.hide();
                $button.removeClass('disabled');
                alert('Ha ocurrido un error de comunicación con el servidor al cargar los feeds.');
            }
        });
    });

    // Asegurarse de que el spinner de "Forzar Ejecución" esté oculto al cargar la página.
    $('#aics-processing-spinner').hide();

    // --- Lógica para el botón de Forzar Ejecución en Ajustes ---
    $('#aics_force_cron').on('click', function(e) {
        e.preventDefault(); // Prevenir el envío del formulario

        var $button = $(this);
        var $spinner = $('#aics-processing-spinner');

        $spinner.show();
        $button.prop('disabled', true);

        $.ajax({
            url: aics_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'aics_force_load_feeds',
                nonce: aics_ajax_object.nonce
            },
            success: function(response) {
                $spinner.hide();
                $button.prop('disabled', false);
                if (response.success) {
                    alert(response.data.message);
                } else {
                    alert('Error: ' + response.data.message);
                }
            },
            error: function() {
                $spinner.hide();
                $button.prop('disabled', false);
                alert('Ha ocurrido un error de comunicación con el servidor.');
            }
        });
    });
});