<?php
/**
 * Proporciona el contenedor principal para la página de AJUSTES con sus pestañas internas.
 */

$active_tab = isset( $_GET['tab'] ) ? sanitize_key( $_GET['tab'] ) : 'sources'; 
?>
<?php require_once plugin_dir_path( __FILE__ ) . 'aics-admin-header.php'; ?>

<div class="wrap"> <!-- El .wrap debe estar en el archivo de la página, no en el header -->
    <nav class="nav-tab-wrapper">
        <a href="?page=ai-content-synthesizer-settings&tab=sources" class="nav-tab <?php echo $active_tab == 'sources' ? 'nav-tab-active' : ''; ?>">Gestión de Fuentes</a>
        <a href="?page=ai-content-synthesizer-settings&tab=settings" class="nav-tab <?php echo $active_tab == 'settings' ? 'nav-tab-active' : ''; ?>">Configuración General</a>
        <a href="?page=ai-content-synthesizer-settings&tab=logs" class="nav-tab <?php echo $active_tab == 'logs' ? 'nav-tab-active' : ''; ?>">Logs de Actividad</a> <!-- NUEVA LÍNEA -->
    </nav>

    <div class="tab-content">
        <?php
        switch ( $active_tab ) {
            case 'settings':
                require_once plugin_dir_path( __FILE__ ) . 'aics-admin-tab-settings.php';
                break;
            case 'logs': // NUEVO CASE
                require_once plugin_dir_path( __FILE__ ) . 'aics-admin-tab-logs.php';
                break;
            case 'sources':
            default:
                require_once plugin_dir_path( __FILE__ ) . 'aics-admin-tab-sources.php';
                break;
        }
        ?>
    </div>
</div>