<?php
/**
 * Contenido para la página principal del Dashboard.
 * Muestra los artículos sintetizados y listos para revisión.
 */

global $wpdb;

// Obtener el valor del filtro desde la URL.
$current_filter = isset($_GET['aics_filter']) ? sanitize_key($_GET['aics_filter']) : 'all';

// --- NUEVO: Calcular los contadores para los filtros ---
$table_name = $wpdb->prefix . 'aics_synthesized_articles';
$base_where = "WHERE status = 'pending_review'";

// Contadores
$count_all = $wpdb->get_var("SELECT COUNT(id) FROM $table_name $base_where");
$count_generated = $wpdb->get_var("SELECT COUNT(id) FROM $table_name $base_where AND meta_description IS NOT NULL AND meta_description != ''");
$count_pending = $wpdb->get_var("SELECT COUNT(id) FROM $table_name $base_where AND (meta_description IS NULL OR meta_description = '')");

// --- FIN: Calcular contadores ---

$query = "SELECT * FROM $table_name WHERE status = 'pending_review'";

// Añadir condiciones a la consulta según el filtro seleccionado.
if ($current_filter === 'generated_ia') {
    $query .= " AND meta_description IS NOT NULL AND meta_description != ''";
} elseif ($current_filter === 'pending_feeds') {
    $query .= " AND (meta_description IS NULL OR meta_description = '')";
}

$query .= " ORDER BY created_at DESC";
$articles = $wpdb->get_results($query);
?>
<?php require_once plugin_dir_path( __FILE__ ) . 'aics-admin-header.php'; ?>

<div class="wrap"> <!-- El .wrap debe estar en el archivo de la página, no en el header -->
    <!-- El formulario ahora engloba también el filtro -->
    <form method="get">
        <input type="hidden" name="page" value="<?php echo esc_attr($_REQUEST['page']); ?>" />
        <?php wp_nonce_field('aics_bulk_action_dashboard', 'aics_dashboard_nonce'); ?>

        <div class="aics-dashboard-container">
        <h3>Artículos Sintetizados Pendientes de Revisión</h3>

        <!-- NUEVO: Filtro estilo subsubsub -->
        <ul class="subsubsub">
            <li class="all">
                <a href="?page=ai-content-synthesizer&aics_filter=all" class="<?php echo $current_filter === 'all' ? 'current' : ''; ?>">
                    Todos <span class="count">(<?php echo esc_html($count_all); ?>)</span>
                </a> |
            </li>
            <li class="generated">
                <a href="?page=ai-content-synthesizer&aics_filter=generated_ia" class="<?php echo $current_filter === 'generated_ia' ? 'current' : ''; ?>">
                    Generados por IA <span class="count">(<?php echo esc_html($count_generated); ?>)</span>
                </a> |
            </li>
            <li class="pending">
                <a href="?page=ai-content-synthesizer&aics_filter=pending_feeds" class="<?php echo $current_filter === 'pending_feeds' ? 'current' : ''; ?>">
                    Feeds Pendientes <span class="count">(<?php echo esc_html($count_pending); ?>)</span>
                </a>
            </li>
        </ul>
        <div class="tablenav top">
            <div class="alignleft actions bulkactions">
                <label for="bulk-action-selector-top" class="screen-reader-text">Seleccionar acción en lote</label>
                <select name="action" id="bulk-action-selector-top">
                    <option value="-1">Acciones en lote</option>
                    <option value="bulk_delete">Eliminar</option>
                </select>
                <input type="submit" id="doaction" class="button action" value="Aplicar">
            </div>
            <div class="alignright actions">                
                <!-- Botón de Cargar Feeds movido a la derecha y con estilo primario -->
                <a href="#" id="aics-load-feeds-btn" class="button button-primary">Cargar Feeds RSS</a>
                <span id="aics-load-feeds-spinner" style="display:none; vertical-align: middle; margin-left: 5px;"><span class="spinner is-active"></span> Cargando...</span>
            </div>
            <br class="clear">
        </div>

        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <td id="cb" class="manage-column column-cb check-column"><input id="cb-select-all-1" type="checkbox"></td>
                    <th scope="col">Título Sugerido</th>
                    <th scope="col" style="width:25%;">Fuente</th>
                    <th scope="col" style="width:30%;">Fecha de Creación</th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td class="manage-column column-cb check-column"><input id="cb-select-all-2" type="checkbox"></td>
                    <th scope="col">Título Sugerido</th>
                    <th scope="col">Fuente</th>
                    <th scope="col">Fecha de Creación</th>
                </tr>
            </tfoot>
            <tbody>
                <?php if (!empty($articles)): ?>
                    <?php foreach ($articles as $article): ?>
                        <tr id="aics-article-row-<?php echo esc_attr($article->id); ?>">
                            <th scope="row" class="check-column"><input type="checkbox" name="article_ids[]" value="<?php echo esc_attr($article->id); ?>"></th>
                            <td>
                                <?php
                                // Si meta_description no está vacío, el artículo ha sido procesado por la IA.
                                $is_ia_generated = !empty($article->meta_description);
                                $style = $is_ia_generated ? 'style="color:green; font-weight:700;"' : 'style="font-weight:500;"';
                                ?>
                                <strong <?php echo $style; ?>><?php echo esc_html($article->title); ?></strong>
                                <div class="row-actions">
                                    <span class="view">
                                        <a href="#"
                                           class="aics-view-content-btn"
                                           data-id="<?php echo esc_attr($article->id); ?>"
                                           data-title="<?php echo esc_attr($article->title); ?>"
                                           data-content="<?php echo esc_attr($article->content); ?>"
                                           data-tags="<?php echo esc_attr($article->suggested_tags ?? ''); ?>"
                                           data-regenerate-on-open="<?php echo $is_ia_generated ? 'false' : 'true'; ?>">
                                            <?php echo $is_ia_generated ? 'Ver contenido generado' : 'Generar contenido'; ?>
                                        </a> |
                                    </span>
                                    <?php // Solo mostrar "Crear Borrador" si el contenido ya ha sido generado por la IA ?>
                                    <span class="edit" <?php if (!$is_ia_generated) echo 'style="display:none;"'; ?>>
                                        <a href="<?php echo wp_nonce_url(add_query_arg(['action' => 'create_draft', 'article_id' => $article->id]), 'aics_single_action_dashboard_' . $article->id); ?>">Crear Borrador</a> |
                                    </span>
                                    <?php
                                    $sources = json_decode($article->source_urls);
                                    $original_url = !empty($sources[0]) ? $sources[0] : '#';
                                    ?>
                                    <span class="view-original">
                                        <a href="<?php echo esc_url($original_url); ?>" target="_blank" rel="noopener noreferrer">Contenido Original</a> |
                                    </span>
                                    <span class="trash">
                                        <a href="<?php echo wp_nonce_url(add_query_arg(['action' => 'delete', 'article_id' => $article->id]), 'aics_single_action_dashboard_' . $article->id); ?>" class="submitdelete" onclick="return confirm('¿Estás seguro de que quieres eliminar este artículo?');">Eliminar</a>
                                    </span>
                                </div>
                            </td>
                            <td>
                                <?php
                                $sources = json_decode($article->source_urls);
                                if (is_array($sources)) {
                                    $hosts = [];
                                    foreach ($sources as $source_url) {
                                        $hosts[] = parse_url($source_url, PHP_URL_HOST);
                                    }
                                    $unique_hosts = array_unique($hosts);
                                    echo implode('<br>', array_map('esc_html', $unique_hosts));
                                }
                                ?>
                            </td>
                            <td><?php echo date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $article->created_at ) ); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4">No hay artículos nuevos generados. El sistema buscará contenido nuevo según la frecuencia de rastreo configurada.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    </form>

    <!-- NUEVO: Estructura de la ventana modal -->
    <div id="aics-content-modal" class="aics-modal" style="display:none;">
        <div class="aics-modal-content">
            <span class="aics-modal-close">&times;</span>
            <div class="aics-modal-header">
                <label for="aics-modal-title-input">Título del Artículo:</label>
                <input type="text" id="aics-modal-title-input" class="large-text">
            </div>
            <div id="aics-modal-tags-container">
                <label for="aics-modal-tags-input">Etiquetas Sugeridas (separadas por comas):</label>
                <input type="text" id="aics-modal-tags-input" class="large-text">
            </div>
            <div id="aics-modal-body" class="post-content">
                <!-- El contenido del artículo se insertará aquí con JS -->
            </div>
            <div class="aics-modal-footer">
                <button id="aics-modal-create-draft" class="button button-secondary">Crear Borrador</button>
                <button id="aics-modal-publish-directly" class="button button-primary">Publicar Ahora</button>
                <button id="aics-modal-schedule" class="button button-secondary">Programar</button>
                <button id="aics-modal-regenerate" class="button button-secondary">Regenerar Contenido</button>
                <span class="spinner"></span>
                <button id="aics-modal-close-footer" class="button button-primary" style="margin-left: auto;">Cerrar</button>
            </div>
            <!-- NUEVO: Contenedor para la programación -->
            <div id="aics-schedule-container" style="display: none;">
                <h4>Programar Publicación</h4>
                <label for="aics-schedule-date">Fecha:</label>
                <input type="date" id="aics-schedule-date">
                <label for="aics-schedule-time">Hora:</label>
                <input type="time" id="aics-schedule-time">
                <button id="aics-schedule-confirm" class="button button-primary">Confirmar Programación</button>
            </div>
        </div>
    </div>
</div>