<?php
/**
 * Contenido para la pestaña de Logs de Actividad.
 */

global $wpdb;
$table_name = $wpdb->prefix . 'aics_logs';

// Paginación
$per_page = 20;
$current_page = isset($_GET['paged']) ? max(1, absint($_GET['paged'])) : 1;
$offset = ($current_page - 1) * $per_page;

$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name");
$total_pages = ceil($total_items / $per_page);

$logs = $wpdb->get_results(
    $wpdb->prepare("SELECT * FROM $table_name ORDER BY log_time DESC LIMIT %d OFFSET %d", $per_page, $offset)
);

?>

<style>
    .log-status {
        padding: 4px 8px;
        border-radius: 4px;
        color: #fff;
        font-weight: bold;
        font-size: 11px;
        text-transform: uppercase;
        display: inline-block;
        min-width: 60px;
        text-align: center;
    }
    .log-status.success { background-color: #00a32a; }
    .log-status.error { background-color: #d63638; }
    .log-status.info { background-color: #72777c; }
</style>

<h3>Registro de Actividad del Motor de Síntesis</h3>
<p>Aquí se muestran los eventos más recientes de la ejecución automática del plugin en segundo plano.</p>

<table class="wp-list-table widefat fixed striped">
    <thead>
        <tr>
            <th scope="col" style="width:20%;">Fecha</th>
            <th scope="col" style="width:15%;">Estado</th>
            <th scope="col">Detalles</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($logs)): ?>
            <?php foreach ($logs as $log): ?>
                <tr>
                    <td><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($log->log_time)); ?></td>
                    <td>
                        <?php
                        $status_class = strtolower($log->status);
                        echo '<span class="log-status ' . esc_attr($status_class) . '">' . esc_html($log->status) . '</span>';
                        ?>
                    </td>
                    <td>
                        <?php echo esc_html($log->details); ?>
                        <?php if ($log->generated_article_id): ?>
                            <br><small>Ver artículo en el <a href="<?php echo admin_url('admin.php?page=ai-content-synthesizer'); ?>">Dashboard</a> (ID de artículo generado: <?php echo esc_html($log->generated_article_id); ?>)</small>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="3">No hay registros de actividad todavía. El primer registro aparecerá después de que el motor se ejecute.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<?php if ($total_pages > 1): ?>
    <div class="tablenav bottom">
        <div class="tablenav-pages">
            <span class="displaying-num"><?php echo esc_html($total_items); ?> elementos</span>
            <span class="pagination-links">
                <?php
                echo paginate_links([
                    'base' => add_query_arg('paged', '%#%'),
                    'format' => '',
                    'prev_text' => __('&laquo;'),
                    'next_text' => __('&raquo;'),
                    'total' => $total_pages,
                    'current' => $current_page,
                ]);
                ?>
            </span>
        </div>
    </div>
<?php endif; ?>