<?php
/**
 * Contenido para la pestaña de gestión de fuentes (C.R.U.D.).
 */

$options = get_option('aics_settings');
$feeds = isset($options['rss_feeds']) ? $options['rss_feeds'] : [];

// Comprobar si estamos en modo edición
$edit_mode = false;
$source_to_edit = null;
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['source_id'])) {
    $edit_id = sanitize_key($_GET['source_id']);
    if (isset($feeds[$edit_id])) {
        $edit_mode = true;
        $source_to_edit = $feeds[$edit_id];
        $source_to_edit['id'] = $edit_id;
    }
}
?>

<div class="aics-sources-manager">
    
    <div class="aics-form-container">
        <h3><?php echo $edit_mode ? 'Editar Fuente' : 'Añadir Nueva Fuente'; ?></h3>
        
        <!-- CORRECCIÓN CLAVE: El atributo 'action' ahora está vacío para que envíe los datos a la URL actual, que es la correcta. -->
        <form method="post" action="">
            
            <input type="hidden" name="action" value="<?php echo $edit_mode ? 'aics_update_source' : 'aics_add_source'; ?>">
            <?php if ($edit_mode): ?>
                <input type="hidden" name="source_id" value="<?php echo esc_attr($source_to_edit['id']); ?>">
            <?php endif; ?>
            <?php wp_nonce_field('aics_source_action', 'aics_source_nonce'); ?>

            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><label for="source_name">Nombre</label></th>
                    <td>
                        <input type="text" id="source_name" name="source_name" value="<?php echo $edit_mode ? esc_attr($source_to_edit['name']) : ''; ?>" class="regular-text" required>
                        <p class="description">Un nombre descriptivo para la fuente (ej. "Noticias de Tecnología").</p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="source_url">URL del Feed</label></th>
                    <td>
                        <input type="url" id="source_url" name="source_url" value="<?php echo $edit_mode ? esc_attr($source_to_edit['url']) : ''; ?>" class="regular-text" placeholder="https://ejemplo.com/feed" required>
                    </td>
                </tr>
            </table>
            
            <?php if ($edit_mode): ?>
                <?php submit_button('Actualizar Fuente'); ?>
                <a href="<?php echo menu_page_url('ai-content-synthesizer-settings', false); ?>&tab=sources" class="button button-secondary">Cancelar Edición</a>
            <?php else: ?>
                <?php submit_button('Añadir Fuente'); ?>
            <?php endif; ?>
        </form>
    </div>

    <hr>

    <div class="aics-list-container">
        <h3>Fuentes Activas</h3>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th scope="col" style="width:30%;">Nombre</th>
                    <th scope="col" style="width:50%;">URL del Feed</th>
                    <th scope="col" style="width:20%;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($feeds)): ?>
                    <?php foreach ($feeds as $id => $feed): ?>
                        <tr>
                            <td><?php echo esc_html($feed['name']); ?></td>
                            <td><code><?php echo esc_url($feed['url']); ?></code></td>
                            <td>
                                <?php
                                $settings_page_url = menu_page_url('ai-content-synthesizer-settings', false);
                                $edit_url = add_query_arg(['action' => 'edit', 'source_id' => $id, 'tab' => 'sources'], $settings_page_url);
                                $delete_nonce = wp_create_nonce('aics_delete_source_' . $id);
                                $delete_url = add_query_arg(['action' => 'delete', 'source_id' => $id, 'tab' => 'sources', '_wpnonce' => $delete_nonce], $settings_page_url);
                                ?>
                                <a href="<?php echo esc_url($edit_url); ?>">Editar</a> | 
                                <a href="<?php echo esc_url($delete_url); ?>" onclick="return confirm('¿Estás seguro de que quieres eliminar esta fuente?');" style="color:#a00;">Eliminar</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3">No hay fuentes configuradas. Añade una usando el formulario de arriba.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>