<?php
/**
 * Plugin Name:       AI Content Synthesizer
 * Plugin URI:        https://example.com/plugins/ai-content-synthesizer/
 * Description:       Automatiza la curación y síntesis de contenido original desde múltiples fuentes RSS utilizando IA.
 * Version:           1.0.1
 * Author:            Tribalio
 * Author URI:        https://tribalio.com/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       ai-content-synthesizer
 * Domain Path:       /languages
 */

// Si este fichero es llamado directamente, abortar.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Función que se ejecuta durante la activación del plugin.
 */
function activate_ai_content_synthesizer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aics-activator.php';
	AICS_Activator::activate();
}

/**
 * Función que se ejecuta durante la desactivación del plugin.
 */
function deactivate_ai_content_synthesizer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aics-deactivator.php';
	AICS_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ai_content_synthesizer' );
register_deactivation_hook( __FILE__, 'deactivate_ai_content_synthesizer' );

/**
 * El núcleo del plugin.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-aics-core.php';

/**
 * Empieza la ejecución del plugin.
 */
function run_ai_content_synthesizer() {

	$plugin = new AICS_Core();
	$plugin->run();

}
run_ai_content_synthesizer();