<?php
/**
 * Se ejecuta durante la activación del plugin.
 */
class AICS_Activator {

	public static function activate() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		// Tabla 1: Artículos Sintetizados (ya existente)
		$table_articles = $wpdb->prefix . 'aics_synthesized_articles';
		$sql_articles = "CREATE TABLE $table_articles (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
			title text NOT NULL,
			content longtext NOT NULL,
			meta_description text,
			suggested_tags text,
			source_urls longtext,
			status varchar(20) DEFAULT 'pending_review' NOT NULL,
			PRIMARY KEY  (id)
		) $charset_collate;";
		dbDelta( $sql_articles );

		// NUEVO: Tabla 2: Logs de Actividad
		$table_logs = $wpdb->prefix . 'aics_logs';
		$sql_logs = "CREATE TABLE $table_logs (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			log_time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
			status varchar(20) NOT NULL,
			details text NOT NULL,
			source_data longtext,
			generated_article_id mediumint(9),
			PRIMARY KEY  (id)
		) $charset_collate;";
		dbDelta( $sql_logs );

		// Programar la tarea CRON (ya existente)
		if ( ! wp_next_scheduled( AICS_CRON_HOOK ) ) {
			wp_schedule_event( time(), 'hourly', AICS_CRON_HOOK );
		}
	}
}