<?php
/**
 * Clase estática para manejar el registro de eventos del plugin.
 */
class AICS_Logger {

    const LOG_LIMIT = 50; // Límite de registros en el log.

    /**
     * Registra un nuevo evento en la base de datos.
     *
     * @param string $status  (e.g., 'SUCCESS', 'ERROR', 'INFO')
     * @param string $details Mensaje detallado del evento.
     * @param array|null $source_data Datos de origen (e.g., el cluster de artículos).
     * @param int|null $generated_article_id ID del artículo generado en la tabla de síntesis.
     */
    public static function log($status, $details, $source_data = null, $generated_article_id = null) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'aics_logs';

        // 1. Insertar el nuevo registro de log.
        $wpdb->insert($table_name, [
            'log_time'             => current_time('mysql'),
            'status'               => sanitize_text_field($status),
            'details'              => sanitize_text_field($details),
            'source_data'          => is_null($source_data) ? null : json_encode($source_data),
            'generated_article_id' => is_null($generated_article_id) ? null : absint($generated_article_id),
        ]);

        // 2. Contar el número total de registros.
        $total_logs = $wpdb->get_var("SELECT COUNT(id) FROM $table_name");

        // 3. Si se supera el límite, eliminar los registros más antiguos.
        if ($total_logs > self::LOG_LIMIT) {
            $logs_to_delete = $total_logs - self::LOG_LIMIT;

            // Se eliminan los registros con el ID más bajo, que son los más antiguos.
            // Esta es la forma más eficiente de hacerlo en MySQL.
            $wpdb->query(
                $wpdb->prepare("DELETE FROM $table_name ORDER BY id ASC LIMIT %d", $logs_to_delete)
            );
        }
    }
}