<?php
/**
 * Fichero que se ejecuta al desinstalar el plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Ai_Content_Synthesizer
 */

// Si no se está desinstalando desde WordPress, salir.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// NOTA: Una buena práctica sería tener una opción en los ajustes del plugin
// para que el usuario decida si quiere eliminar los datos al desinstalar.
// Por ahora, implementaremos la limpieza completa.

// 1. Eliminar las opciones del plugin
delete_option( 'aics_settings' );

// 2. Eliminar las tablas personalizadas de la base de datos
global $wpdb;
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}aics_synthesized_articles" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}aics_logs" );